import openai
from openai import OpenAI
import httpx

def dataframe_to_sentence(df):
    sentences = ''
    first_col = df.columns[0]  # 找到第一列的列名
    for index, row in df.iterrows():
        sentence = f"{first_col} {row[first_col]}"
        for column in df.columns[1:]:
            sentence += f", {column} is {row[column]}"
        sentence += ". "
        sentences += sentence
    return sentences

def get_triples_context(df):
    triples = []
    first_col = df.columns[0]  # Automatically find the first column name
    for index, row in df.iterrows():
        for column in df.columns[1:]:
            first = str(first_col) + ' ' + str(row[first_col])
            triples.append((first, column, row[column]))
    context_list = [f"{head}'s {relation} is {tail}" for head, relation, tail in triples]
    context = '. '.join(context_list)
    return context

def get_triples_answer(title,table_context,question):
    with open('/home/yangzhen/code/tablellm/prompt/wtq/triples.txt') as f:
        prompt_context = f.read()
    prompt = prompt_context.format(TABLE=table_context,TITLE=title,QUESTION=question)
    messages = [{"role": "user", "content": prompt}]
    try:
        # api_key = 'sk-YangZhen_230909_jyCRb1M58DIlmLfuvutK'
        # base_url = 'https://chat.aitsc.top:10001/chatapi/nostat/v1'
        # model = 'glm-4-public'
        # client = OpenAI(api_key=api_key, base_url=base_url)
        # completion = client.chat.completions.create(
        #     model=model,
        #     messages=messages,
        #     temperature=0.4,
        #     max_tokens=4980,
        # )
        api_key = 'sk-WXHpiXK1XnYZ0pffA5E3Cf358a93469cB50987Bf161041C3'
        client = OpenAI(
            base_url="https://threefive.gpt7.link/v1",
            api_key=api_key,
            http_client=httpx.Client(
                base_url="https://threefive.gpt7.link/v1",
                follow_redirects=True,
            ),
        )
        completion = client.chat.completions.create(
            model='gpt-3.5-turbo',
            messages=messages,
            temperature=0.4,
            max_tokens=4980
        )
        result = completion.choices[0].message.content
        if 'Final Answer: ' in result:
            #answer = result.split('Final Answer: ')[1].strip('.')
            return result, completion
    except Exception as e:
        print('get_triples_answer error, ', e)
        answer = completion = 'error'
        return answer, completion