"""This is the entry point of the code when running using submitit"""

import os
import sys

import submitit

from codes.app.main import run
from codes.utils.argument_parser import argument_parser

config_id = argument_parser()

config_id = "supervised/signature_learn"

# We are using Slurm Executor as it allows us to set the gres flag
executor = submitit.SlurmExecutor(folder="~/logs/lgw/%j")

executor.update_parameters(
    # timeout_min=4,
    partition="dev",
    gres="gpu:1",
    job_name="test",
    time="5",
)

job = executor.submit(run, config_id)

print(job.job_id)  # ID of your job

output = (
    job.result()
)  # waits for the submitted function to complete and returns its output

print("finished")
