"""This is the main entry point for the code"""

from codes.grad_student.checkpointable_grad_student import CheckpointableGradStudent
from codes.utils.argument_parser import argument_parser
from codes.utils.util import timing


@timing
def run(config_id: str) -> None:
    """Run the code"""

    grad_student = CheckpointableGradStudent(config_id)
    grad_student.run()


@timing
def evaluate(config_id: str, epoch=None) -> None:
    """ Evaluate on saved models
    """
    grad_student = CheckpointableGradStudent(config_id, load_checkpoint=False)
    grad_student.evaluate(epoch=epoch)


if __name__ == "__main__":
    # config_id = "maml/maml_exp_icml_6"
    # config_id = "multitask/multitask_uc_icml_5"
    # run(config_id=config_id)
    # evaluate(config_id=config_id)
    run(config_id=argument_parser())
    # evaluate(config_id=argument_parser())
