import abc
import os

class EpisodesReader(abc.ABC):
    """
    An EpisodesReader contains episodes, which are dictionaries of the from: 
    {
        'observations': np.ndarray[T, ...], T the episode length
        'next_observations': np.ndarray[T, ...], T the episode length 
        'actions': np.ndarray[T, ...], T the episode length
        'dones': np.ndarray[T, ...], T the episode length
        'infos': dict
    }
    It allows the loading of trajectory data in different forms into a common one.
    """

    def __init__(self):
        self.episodes = []
        self.lengths = []
    
    def __len__(self):
        return len(self.episodes)

    def get_ids(self):
        return list(range(len(self.episodes)))

    def __getitem__(self, idx):
        return self.episodes[idx]