import sys
from omegaconf import OmegaConf

SimpleNamespace = type(sys.implementation)

class ConfigDict(SimpleNamespace):
    def __contains__(self, key):
        return key in self.__dict__

    def keys(self):
        return self.__dict__.keys()

    def __getitem__(self, key):
        return getattr(self, key)

def _recursive_convert_to_configdict(cfg):
    for key, value in cfg.__dict__.items():
        if isinstance(value, dict):
            setattr(cfg, key, ConfigDict(**value))
            _recursive_convert_to_configdict(getattr(cfg, key))

def omegaconf_to_conf(omegacfg):
    dict_cfg = OmegaConf.to_object(omegacfg)
    cfg = ConfigDict(**dict_cfg)
    _recursive_convert_to_configdict(cfg)
    return cfg