import numpy as np
from gmpy2 import mpz
from compute_patterns import compute_patterns_bin_fixed, compute_diversity
import pickle
import os
import re

table = {}

for dir_name in os.listdir('./patterns_out/'):
    if dir_name == 'iris_2d_s' or dir_name == 'iris_2d_ns':
        continue
    parts = re.split('_', dir_name)
    key = "_".join(parts[0:len(parts)-1])
    for file_name in os.listdir("./patterns_out/{}".format(dir_name)):
        if file_name == 'patterns_file':
            #print(key)
            with open("./patterns_out/{}/patterns_file".format(dir_name), 'rb') as file:
                patterns = pickle.load(file)
                if not key in table:
                    table[key] = {'patterns': 0, 'files_count': 0}
                table[key]['patterns'] = table[key]['patterns'] + len(patterns)
                table[key]['files_count'] = table[key]['files_count'] + 1

print("dataset, patterns, files_count")
keys = list(table.keys())
keys.sort()
for key in keys:
    print("{}, {}, {}".format(key, table[key]['patterns'], table[key]['files_count']))
    


