import pandas as pd

from sklearn.decomposition import PCA

import argparse

def apply_PCA(csv_path, output_path, target_name, num_features):
    df = pd.read_csv(csv_path, dtype=float)
    y = df[target_name]
    X = df.drop(target_name, axis=1)

    clf = PCA(n_components=num_features)
    X = clf.fit_transform(X, y)

    X = pd.DataFrame(X)

    X[target_name] = y

    X.to_csv(output_path, index=False)

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Applies PCA on a dataset in csv format')
    parser.add_argument('-c', '--csv_path', default='./csv/wine.csv')
    parser.add_argument('-o', '--output_path', default='./csv/wine_pca.csv')
    parser.add_argument('-t', '--target', default='class')
    parser.add_argument('-f', '--num_features', default=4, type=int)

    args = parser.parse_args()

    apply_PCA(
        csv_path=args.csv_path,
        output_path=args.output_path,
        target_name=args.target,
        num_features=args.num_features,
    )