import os
import re
def get_files(folder_path):
    file_list = []

    for file_name in os.listdir(folder_path):
        if file_name.endswith('.csv'):  # Replace '.txt' with the extension of the files you want to list
            file_path = os.path.join(folder_path, file_name)
            file_list.append(file_path)

    print(file_list)
    return file_list

with open('run_dp.sh_template', 'r') as file:
    template = file.read()

for filename in get_files('../data_real/generated/'):
    dataset_name = re.split('\.|/', filename)[-2]
    out_file = "run_dp_{}.sh".format(dataset_name)
    content = template.replace('<%dataset%>', dataset_name)
    with open(out_file, "w") as text_file:
        text_file.write(content)
        
with open('run_get_patterns.sh_template', 'r') as file:
    template = file.read()

for filename in get_files('../data_real/generated/'):
    dataset_name = re.split('\.|/', filename)[-2]
    out_file = "run_get_patterns_{}.sh".format(dataset_name)
    content = template.replace('<%dataset%>', dataset_name)
    with open(out_file, "w") as text_file:
        text_file.write(content)