from config import Parser
from utils.func import random_seed, model_load
from data.loader import get_data
from algs.model import get_model
from run.train import train
from run.eval import evaluate

def run(args):
    random_seed(args.seed)
    loaders = get_data(args)
    models = get_model(args)
    
    if 'train' in args.job:
        random_seed(args.seed)
        train(models, loaders, args)
    
    if 'test' in args.job:
        random_seed(args.seed)
        evaluate(loaders, args.ckpt_path, args.device, args.log)
    
if __name__ == '__main__':
    run(Parser().parse())



