from datetime import datetime
from utils.func import *
import logging


def level_info(log_level):
        if log_level == 'debug':
                return logging.DEBUG
        elif log_level == 'info':
                return logging.INFO
        elif log_level == 'warning':
                return logging.WARNING
        elif log_level == 'error':
                return logging.ERROR

def logger(args):
        __logger = logging.getLogger('Debiasing feature bias with noisy labels')
        __logger.setLevel(level_info(args.log))
        formatter = logging.Formatter('(%(asctime)s): %(message)s')

        sthandler = logging.StreamHandler()
        sthandler.setFormatter(formatter)
        __logger.addHandler(sthandler)

        if args.save == 'True':
                mode = 'w'
                
                now = datetime.now()
                current_time = 'debug' if 'debug' in args.run else '%s-%s-%s-%s-%s-%s' %(now.year,now.month,now.day, now.hour, now.minute, now.second)
                fhandler = logging.FileHandler(args.log_path+current_time+'-'+args.log+'.log', mode=mode)
                fhandler.setFormatter(formatter)
                __logger.addHandler(fhandler)

        return __logger
