import torch as t
import numpy as np
import os


def random_seed(seed):
    t.manual_seed(seed)
    t.backends.cudnn.deterministic = True
    t.backends.cudnn.benchmark = False
    np.random.seed(seed)

def gen_path(dir):
    try:
        os.makedirs(dir)
    except:
        pass

def model_save(model,model_dir,status):
    t.save(model, model_dir+'model_'+status+'.pt')


def model_load(model_dir,status):
    return t.load(model_dir+'model_'+status+'.pt')
