# TINA: 


random_prune.py: for applying vanilla l1, local neurons selection. Single shot of neurons removal, then finetune remaining neurons.
few_shot_prune.py: vanilla l1, local, and global neurons selection.



python -m torch.distributed.launch --nproc_per_node 4 --master_port 54321 random_prune.py \
       --cfg configs/swin_tiny_patch4_window7_224.yaml --batch-size 128 --dsets_type cifar-100 \
       --exp_name EXPERIMENT_NAME \
       --model_type swin_adapters  --finetune 3 --type_adapters series --size_adapters SIGMA_0 \
       --ssl_warmup_epochs 20 --total_epochs 100 --prune_type layerwise --prune_amount 0.875 --prune_struct "structured" \
       --amp-opt-level O2 --seed 0 --range 2 --weighted 0 --scaling 0

python -m torch.distributed.launch --nproc_per_node 4 --master_port 54321 few_shot_prune.py \
       --cfg configs/swin_tiny_patch4_window7_224.yaml --batch-size 512 --dsets_type flowers102 \
       --exp_name EXPERIMENT_NAME \
       --model_type swin_adapters  --finetune 6 --type_adapters series --size_adapters SIGMA_0 \
       --ssl_warmup_epochs 20 --total_epochs 60 --prune_type TYPE_OF_NEURONS_SELECTION --prune_amount RHO(0.5, 0.8 ...) --prune_struct "structured" \
       --amp-opt-level O2 --seed 0 --range CYCLES --weighted 0 --scaling 1

#### TYPES of neurons selection are: 
-> down_magnitude: vanilla l1 neurons selection
-> magnitude: local neurons selection
-> layerwise: global neurons selection (--scaling 0, or --scaling 1 for normalization)



### Examples
** TINA for Series Adapters for Swin-T model with sigma_0 = 128 for 5 cycles, each cycle trains for 100. We remove 0.75 of neurons, and then we finetune.

python -m torch.distributed.launch --nproc_per_node 4 --master_port 54321 random_prune.py \
       --cfg configs/swin_tiny_patch4_window7_224.yaml --batch-size 128 --dsets_type flowers102 \
       --exp_name Ablation_Series_GlobalMagnitudePrune128_05_SEED0_FS \
       --model_type swin_adapters  --finetune 3 --type_adapters series --size_adapters 32 \
       --ssl_warmup_epochs 20 --total_epochs 100 --prune_type layerwise --prune_amount 0.75 --prune_struct "structured" \
       --amp-opt-level O2 --seed 0 --range 5 --weighted 0 --scaling 0


** TINA for Series Adapters for Swin-T model with sigma_0 = 32 for 8 cycles, each cycle trains for 100

python -m torch.distributed.launch --nproc_per_node 4 --master_port 54321 few_shot_prune.py \
       --cfg configs/swin_tiny_patch4_window7_224.yaml --batch-size 128 --dsets_type flowers102 \
       --exp_name Ablation_Series_GlobalMagnitudePrune128_05_SEED0_FS \
       --model_type swin_adapters  --finetune 3 --type_adapters series --size_adapters 32 \
       --ssl_warmup_epochs 20 --total_epochs 100 --prune_type layerwise --prune_amount 0.5 --prune_struct "structured" \
       --amp-opt-level O2 --seed 0 --range 8 --weighted 0 --scaling 1