#!/bin/bash
set -e

ROOT_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)

download_file() {
   local DIR="$ROOT_DIR/$1"
   local URL=$2
   local FILE=$(basename $URL)

   mkdir -p "$DIR"
   wget -N --progress=bar:force --no-check-certificate $URL -P $DIR
   if [ $? -eq 0 ]; then
       return 0
   else
       echo "Download of $URL failed."
       exit 1
   fi
}

extract_file() {
    local DIR="$ROOT_DIR/$1"
    local FILE=$(basename $2)

    unzip -o "$DIR/$FILE" -d "$DIR"
    rm "$DIR/$FILE"
}

download_and_extract() {
   download_file $1 $2
   extract_file $1 $2
}

# Downloads training datasets from https://srm.epfl.ch/srm/dataset/challenge-3D-simulation/index.html

#download_and_extract "MT0N1LDAS" "https://srm.epfl.ch/srm/Data/challenge-3D-simulation/MT0.N1.LD/Data/sequence-MT0.N1.LD-AS-Exp-as-stack.zip"
#download_file "MT0N1LDAS" https://srm.epfl.ch/srm/dataset/challenge-3D-simulation/MT0.N1.LD/sample/activations.csv

download_and_extract "MT0N1HDAS" "https://srm.epfl.ch/srm/Data/challenge-3D-simulation/MT0.N1.HD/Data/sequence-MT0.N1.HD-AS-Exp-as-stack.zip"
download_file "MT0N1HDAS" https://srm.epfl.ch/srm/dataset/challenge-3D-simulation/MT0.N1.HD/sample/activations.csv

#download_and_extract "MT0N2LDAS" "https://srm.epfl.ch/srm/Data/challenge-3D-simulation/MT0.N2.LD/Data/sequence-MT0.N2.LD-AS-Exp-as-stack.zip"
#download_file "MT0N2LDAS" https://srm.epfl.ch/srm/dataset/challenge-3D-simulation/MT0.N2.LD/sample/activations.csv

#download_and_extract "MT0N2HDAS" "https://srm.epfl.ch/srm/Data/challenge-3D-simulation/MT0.N2.HD/Data/sequence-MT0.N2.HD-AS-Exp-as-stack.zip"
#download_file "MT0N2HDAS" https://srm.epfl.ch/srm/dataset/challenge-3D-simulation/MT0.N2.HD/sample/activations.csv

#download_and_extract "BeadsAS/" "https://srm.epfl.ch/datasets/challenge2016/beads/z-stack-Beads-AS-Exp-as-stack.zip"
#download_file "BeadsAS/" "https://pastebin.com/raw/Xbny5NCf"
#mv "BeadsAS/Xbny5NCf" "BeadsAS/activations.csv"

#download_file "TubulinA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/Tubulin-A647-3D/Data/Tubulin-A647-3D-stacks_1.tif"
#download_file "TubulinA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/Tubulin-A647-3D/Data/Tubulin-A647-3D-stacks_2.tif"
#download_file "TubulinA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/Tubulin-A647-3D/Data/Tubulin-A647-3D-stacks_3.tif"
#download_file "TubulinA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/Tubulin-A647-3D/Data/Tubulin-A647-3D-stacks_4.tif"

# download_file "NPCA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/NPC-A647-3D/Data/NPC-A647-3D-stack_1.tif"
# download_file "NPCA647" "https://srm.epfl.ch/srm/Data/challenge-3D-real/NPC-A647-3D/Data/NPC-A647-3D-stack_2.tif"
