from torch import Tensor


def digitalization(y: Tensor, inv_e_adu: float, adu_baseline: float) -> Tensor:
    return digitalization_gain(
        y, inv_e_adu=inv_e_adu, adu_baseline=adu_baseline
    ).floor()


def digitalization_gain(y: Tensor, inv_e_adu: float, adu_baseline: float) -> Tensor:
    return inv_e_adu * y + adu_baseline


def digitalization_jac(y: Tensor, inv_e_adu: float) -> Tensor:
    return inv_e_adu * y


def reciprocal_digitalization_gain(
    y: Tensor, inv_e_adu: float, adu_baseline: float
) -> Tensor:
    return (y - adu_baseline) / inv_e_adu
