import torch

from smlmsim.camera.camera import camera_noise
from smlmsim.utils.hash import hash_tensor


def test_reproducibility():
    c, h, w = 3, 32, 32
    y = torch.linspace(-1, 1, c * h * w).view(c, h, w)
    gen = torch.Generator().manual_seed(0)
    out = camera_noise(
        y=y,
        quantum_efficiency=0.9,
        spurious_charge=0.02,
        em_gain=300,
        readout_noise=0.9,
        camera_type="EMCCD",
        gen=gen,
    )
    assert hash_tensor(out) == 4311656961376700157
