import os


def hash_tensor(tensor):
    """
    Hashes a Pytorch tensor/numpy array (in a trivial / non-cryptographic way).
    """
    if "PYTHONHASHSEED" in os.environ:
        if os.environ["PYTHONHASHSEED"] != "1":
            raise ValueError("Environment variable 'PYTHONHASHSEED' must be set to 1.")
    else:
        os.environ["PYTHONHASHSEED"] = "1"
    return hash(tuple(tensor.flatten().tolist()))
