from torch import Tensor

from smlm.activations.io import WriterInterface


class CombineWriters(WriterInterface):
    def __init__(self, writer1: WriterInterface, writer2: WriterInterface):
        self.writer1 = writer1
        self.writer2 = writer2

    def open(self):
        self.writer1.open()
        self.writer2.open()

    def close(self):
        self.writer1.close()
        self.writer2.close()

    def _write(self, data: Tensor):
        self.writer1._write(data=data)
        self.writer2._write(data=data)
