def compute_tp_fp_fn(num_matches: int, num_preds: int, num_gts: int):
    tp = num_matches
    fp = num_preds - tp
    fn = num_gts - tp
    return tp, fp, fn


def compute_jaccard(tp: int, fp: int, fn: int, eps: float = 1e-12):
    if fp == 0 and fn == 0:
        return 1.0
    return tp / (tp + fp + fn + eps)


def compute_precision(tp: int, fp: int, eps: float = 1e-12):
    if fp == 0:
        return 1.0
    return tp / (tp + fp + eps)


def compute_recall(tp: int, fn: int, eps: float = 1e-12):
    if fn == 0:
        return 1.0
    return tp / (tp + fn + eps)


# Example usage:
if __name__ == "__main__":
    from .matching import match
    import numpy as np

    gt = np.array([[1000, 2000, 0], [17500, 29500, -300], [3200, 5400, 500]])
    pred = np.array(
        [[1100, 1900, 100], [1000, 1900, 100], [0, 0, 0], [17500, 29500, 300]]
    )

    row_idx, col_idx = match(pred=pred, gt=gt)
    tp, fp, fn = compute_tp_fp_fn(
        num_matches=len(row_idx), num_preds=len(pred), num_gts=len(gt)
    )
    print("True Positives:", tp)
    print("False Positives:", fp)
    print("False Negatives:", fn)
