import numpy as np


def compute_2d_efficiency(jaccard: float, rmse: float, alpha: float):
    E = 1.0 - np.sqrt(np.square(1 - jaccard) + np.square(alpha * rmse))
    return E.item()


def compute_lat_efficiency(jaccard: float, rmse_lat: float):
    return compute_2d_efficiency(jaccard=jaccard, rmse=rmse_lat, alpha=1e-2)


def compute_axial_efficiency(jaccard: float, rmse_axial: float):
    return compute_2d_efficiency(jaccard=jaccard, rmse=rmse_axial, alpha=5e-3)


def compute_3d_efficiency(jaccard: float, rmse_lat: float, rmse_axial: float) -> float:
    e_lat = compute_lat_efficiency(jaccard=jaccard, rmse_lat=rmse_lat)
    e_axial = compute_axial_efficiency(jaccard=jaccard, rmse_axial=rmse_axial)
    return 0.5 * (e_lat + e_axial)
