import numpy as np


def compute_rmse(matched_pred: np.ndarray, matched_gt: np.ndarray):
    if len(matched_gt.shape) != 2 or len(matched_pred.shape) != 2:
        raise ValueError("coordinates shape should be (N, d).")
    if len(matched_gt) != len(matched_pred):
        raise ValueError("coordinates sets should contain the same number of elements.")
    if len(matched_gt) == 0:
        return 0.0
    diff = np.square(matched_pred - matched_gt)
    x = np.sqrt(diff.sum(axis=-1).mean())
    return x.item()
