from torch import nn


def count_parameters(model: nn.Module) -> int:
    """Count the number of trainable parameters in a PyTorch model."""
    return sum(p.numel() for p in model.parameters() if p.requires_grad)


def present_model(model: nn.Module):
    """Present a model in the logs"""
    print(f"Model '{model._get_name()}'; {count_parameters(model):,} parameters.")
