# Provable Identifiability of ReLU Neural Networks via LASSO Regularization

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)


## Introduction

We propose a neural network-based variable selection method. Specifically, given a neural network whose output $y$ depends only on a small subset of input $\boldsymbol{x}$, denoted by $\mathcal{S}^{\star}$, we prove that the LASSO estimator can stably reconstruct the neural network and identify $\mathcal{S}^{\star}$ when the number of samples scales logarithmically with the input dimension.

`DL` folder includes following files:
- `__init__.py`: initial file
- `_plot_cfg.py`: plotting configuration file
- `gendata.py`: functions for data generation
- `model.py`: functions for constructing and training nerual networks
- `utils.py`: other supporting functions

We also include two scripts `exp_sim.py` and `exp_sim.py` to reproduce the simulated and real dataset experiments in our paper, respectively. 


## Requirements
- Python >= 3.6
- numpy~=1.20.1
- pandas~= 1.2.3
- scikit-learn~=0.24.1
- mpi4py~=3.0.3
- matplotlib~=3.3.4
