import numpy as np
import os

datasets = ["DIC-C2DH-HeLa", "Fluo-N2DH-SIM+", "Fluo-N2DL-HeLa", "PhC-C2DL-PSC", "Fluo-N2DH-GOWT1"]
seqs = ["01", "02"]
measures_sh = ["DETMeasure.sh", "SEGMeasure.sh", "TRAMeasure.sh"]

values_to_avg = []
print("\t\tDET\tSEG\tTRA\tcsb\tctb")
for d in datasets:
    d_path = "../{}".format(d)
    for seq in seqs:
        seq_path = os.path.join(d_path, "{}_RES".format(seq))
        if not os.path.exists(seq_path):
            continue
        if not (len(os.listdir(seq_path)) > 4):
            continue
        args = "{} {} 3".format(d_path, seq)
        try:
            det = float(os.popen('./evaluation/DETMeasure.sh {}'.format(args)).read().split()[-1])
        except ValueError as e:
            det = 0
        try:
            seg = float(os.popen('./evaluation/SEGMeasure.sh {}'.format(args)).read().split()[-1])
        except ValueError as e:
            seg = 0
        try:
            tra = float(os.popen('./evaluation/TRAMeasure.sh {}'.format(args)).read().split()[-1])
        except ValueError as e:
            tra = 0

        csb = 0.5 * (det + seg)
        ctb = 0.5 * (seg + tra)
        values_to_avg.append((csb+ctb)*0.5)
        print("{}_{}: {:.5f} {:.5f} {:.5f} {:.5f} {:.5f}".format(d, seq, det, seg, tra, csb, ctb))
print("Average: {:.5f}".format(np.mean(values_to_avg)))
