import os
from pathlib import Path


def backup(dir):
    """Back up the current source code folder for ease of replication."""

    dir = Path(dir)
    # the folder should not exist yet!
    try:
        dir.mkdir(parents=True)
    except:
        print('Dir exists')

    # copy the source code from git info
    src = Path(os.getcwd()) / 'vmoe'
    for root, _, files in os.walk(src):
        for file in files:
            if file.endswith(".py") or file.endswith(".sh"):
                rel = Path(root).relative_to(src)
                (dir / rel).mkdir(parents=True, exist_ok=True)
                (dir / rel / file).write_text((src / rel / file).read_text())


if __name__ == "__main__":
    backup("backup")
