import argparse
import json
import os
import torch
from exp.exp_long_term_forecasting import Exp_Long_Term_Forecast
import random
import numpy as np
from sklearn.metrics import r2_score, mean_squared_error, mean_absolute_error
from data_provider.data_factory import data_provider
from torch.utils.data import DataLoader
from data_provider.data_loader import Dataset_ETT_hour, Dataset_ETT_minute, Dataset_Custom,Dataset_Solar
def train(ii,args):
    setting = '{}_pl{}_n_layers_{}_d_model_{}_dropout_{}_pe_type_{}_bs_{}_lr_{}'.format(
                    args.data_path[:-4],
                    args.pred_len,
                    args.n_layers,
                    args.d_model,
                    args.dropout,
                    args.pe_type,
                    args.batch_size,
                    args.learning_rate,
                    )

    exp = Exp(args)  # set experiments
    print(f'>>>>>>>start training : {setting}>>>>>>>>>>>>>>>>>>>>>>>>>>')
    exp.train(setting)
    print(f'>>>>>>>testing : {setting}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
    exp.test(setting,test=1)
    print(f'>>>>>>>shap analysis : {setting}<')
    exp.shap_analysis()
    torch.cuda.empty_cache()
    
    
if __name__ == '__main__':
    fix_seed = 2021
    random.seed(fix_seed)
    torch.manual_seed(fix_seed)
    np.random.seed(fix_seed)

    parser = argparse.ArgumentParser(description='Leddam')
    # basic config
    parser.add_argument('--kernel_size', type=int, default=25, help='kernel_size hyperparameter of smoothing')
    parser.add_argument('--task_name', type=str, required=True, default='long_term_forecast')
    parser.add_argument('--is_training', type=int, required=True, default=1, help='status')
    parser.add_argument('--model_id', type=str, required=True, default='test', help='model id')
    parser.add_argument('--model', type=str, required=True, default='Leddam')
    # data loader
    parser.add_argument('--data', type=str, required=True, default='custom', help='dataset type')
    parser.add_argument('--root_path', type=str, default='', help='root path of the data file')
    parser.add_argument('--data_path', type=str, default='data.csv', help='data file')
    #parser.add_argument('--predict_path', type=str, default='data_y.csv',  help='data file for prediction')
    parser.add_argument('--features', type=str, default='MS',
                        help='forecasting task, options:[M, S, MS]; M:multivariate predict multivariate, S:univariate predict univariate, MS:multivariate predict univariate')
    parser.add_argument('--target', type=str, default='OT', help='target feature in S or MS task')
    parser.add_argument('--freq', type=str, default='m',
                        help='freq for time features encoding, options:[s:secondly, t:minutely, h:hourly, d:daily, b:business days, w:weekly, m:monthly], you can also use more detailed freq like 15min or 3h')
    parser.add_argument('--checkpoints', type=str, default='./checkpoints', help='location of model checkpoints')
    # forecasting task
    parser.add_argument('--seq_len', type=int, default=96, help='input sequence length of backbone model')#96
    parser.add_argument('--label_len', type=int, default=48, help='start token length')
    parser.add_argument('--pred_len', type=int, default=96, help='prediction sequence length')#96
    # model define
    parser.add_argument('--enc_in', type=int, default=11, help='encoder input size')  # adjusted-9
    parser.add_argument('--d_model', type=int, default=256, help='model input size')
    parser.add_argument('--dec_in', type=int, default=11, help='decoder input size')  # adjusted-9
    parser.add_argument('--c_out', type=int, default=11, help='output size')  # adjusted-9
    parser.add_argument('--n_layers', type=int, default=3, help='n_layers of DEFT Block')
    parser.add_argument('--pe_type', type=str, default='no', help='position embedding type')
    parser.add_argument('--dropout', type=float, default=0., help='dropout ratio')
    parser.add_argument('--revin', type=bool, default=True, help='using revin from non-stationary transformer')
    # The rest of your code remains the same
    # optimization
    parser.add_argument('--num_workers', type=int, default=0, help='data loader num workers')
    parser.add_argument('--itr', type=int, default=1, help='experiments times')
    parser.add_argument('--train_epochs', type=int, default=100, help='train epochs')
    parser.add_argument('--batch_size', type=int, default=32, help='batch size of train input data')
    parser.add_argument('--patience', type=int, default=6, help='early stopping patience')
    parser.add_argument('--learning_rate', type=float, default=1e-4, help='optimizer learning rate')
    parser.add_argument('--des', type=str, default='test', help='exp description')
    parser.add_argument('--loss', type=str, default='mse', help='loss function')
    parser.add_argument('--lradj', type=str, default='constant', help='adjust learning rate')
    parser.add_argument('--use_amp', type=bool, default=True, help='use automatic mixed precision training')
    # GPU
    parser.add_argument('--use_gpu', type=bool, default=True, help='use gpu')
    parser.add_argument('--gpu', type=int, default=0, help='gpu')
    parser.add_argument('--use_multi_gpu', action='store_true', help='use multiple gpus', default=False)
    parser.add_argument('--devices', type=str, default='0,1,2,3', help='device ids of multile gpus')
    args = parser.parse_args()
    args.use_gpu = True if torch.cuda.is_available() and args.use_gpu else False
    if args.use_gpu and args.use_multi_gpu:
        args.devices = args.devices.replace(' ', '')
        device_ids = args.devices.split(',')
        args.device_ids = [int(id_) for id_ in device_ids]
        args.gpu = args.device_ids[0]        
    args.label_len=int(args.seq_len//2)
    Exp = Exp_Long_Term_Forecast
    print('Args in experiment:')
    print(args)
    train(1,args) 
    
    
            
                      