"""main.py"""

import argparse

import numpy as np

from digitclut_solver import Solver

import sys
sys.path.append("..") # Adds higher directory to python modules path.

#from helper import str2bool



def main(args):
    seed = args.seed
    np.random.seed(seed)
    data = Solver(args)
    data.create_train_set()
    data.create_generalisation_set()


        
if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='DigitDataset')
    
    #Image params
    parser.add_argument('--n_letters', default=2, type=int, help='number of letters per image')
    parser.add_argument('--digit_colour_type', default='b_w_e', type=str, help='colours of digit: b_w or b_w_e')
    parser.add_argument('--offset', default='fixed_unoccluded', type=str, help='type of offset of digits: fixed_unoccluded, random_unoccluded, fixed_occluded, random_occluded, hidden traverse ')
    parser.add_argument('--font_set', default='fixed', type=str, help='fixed or random font set')

    #Image hyperparams
    parser.add_argument('--linewidth', default=15, type=int, help='width of edgde around digits')
    parser.add_argument('--fontsize', default=220, type=int, help='size of digits within image')
    parser.add_argument('--image_size', nargs='+', default= (256, 256) , type=int, help='size of png image')
    
    #Dataset Hyperparams
    #parser.add_argument('--FILENAME', default='../../data/', type=str, help='where to save folder')
    parser.add_argument('--seed', default=1, type=int, help='random seed')
    parser.add_argument('--n_samples_train', default=100000, type=int, help='number of train images')
    parser.add_argument('--n_samples_test', default=10000, type=int, help='number of test images')
    
    #parser.add_argument('--unflip', default=False, type=bool, help='keep half images from being flipped')

    #parser.add_argument('--cont', default=False, type=str2bool, help='continue with generating dataset which was already started to generate')
   
    args = parser.parse_args()
    
    vars(args)['FILENAME'] = '_data/digclut' + str(args.n_letters)


    main(args)
