"""Determine the effective parameters of models in a given number of folders.
"""

import sys
import os
import argparse

import numpy as np
import pandas as pd
from tqdm import tqdm

sys.path.append('')
import functions.sgc_resnets as sgc

def main(args):
    df = pd.DataFrame({
        'nonrec_summary': [],
        'first_weights': [],
        'mean': [],
        'dev': [],
        'key': [],
        'folder': []
    })
    for folder in tqdm(args.folders):
        path = os.path.join(args.path, folder, 'default')
        for model_folder in os.listdir(path):
            model_path = os.path.join(path, model_folder, 'checkpoints')
            for ckpt in os.listdir(model_path):
                ckpt_name = ckpt.split('.')[0]
                new_key = model_folder + '_' + ckpt_name
                full_path = os.path.join(model_path, ckpt)
                model = sgc.SGCResNetModule.load_from_checkpoint(full_path, reload=True)\
                                           .eval()\
                                           .to(args.device)
                new_df = model.model.effective_parameters()
                new_df['key'] = np.array([new_key]*len(new_df))
                new_df['folder'] = np.array([folder]*len(new_df))
                df = df.append(new_df)
    df.to_csv(args.savepath)

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('path')
    parser.add_argument('savepath')
    parser.add_argument('folders', type=str, nargs='+')
    parser.add_argument('--device', type=str, default='cuda')
    args = parser.parse_args()
    main(args)
