import numpy as np


def onehot(arr, minlength=None):

    length = np.amax(arr) + 1
    if minlength is not None:
        length = max(minlength, length)
    result = np.zeros(arr.shape + (length,), dtype=np.float32)
    result[tuple(list(np.indices(arr.shape)) + [arr])] = 1
    return result
