import sigpy.mri
import numpy as np
import torch
from math import floor, ceil
import os

def create_masks(dir_output,
                 shape_z=320,
                 shape_y=320,
                 acc=(3,4,6,8),
                 shape_calib=1,
                 num_repeat=4):
    """Create sampling masks using sigpy poisson."""
    if not os.path.exists(dir_output):
        os.mkdir(dir_output)
    for a in acc:
        for i in range(num_repeat):
            random_seed = 1e6 * np.random.random()
            file_name = 'mask_r%0.2g_c%d_i%d.npy' % (a, shape_calib, i)
            file_name = os.path.join(dir_output, file_name)
            mask = sigpy.mri.poisson([shape_z, shape_y],
                                     a,
                                     calib=[shape_calib] * 2,
                                     seed=random_seed)
            np.save(file_name, mask.astype(np.complex64))
    
create_masks('',
             shape_z=320,
             shape_y=320,
             acc=(3,),
             shape_calib=16,
             num_repeat=40)