# Column Precision Guardian - Three-Artifact Version

This is a three-artifact implementation of the column_precision_guardian agent, focused on strict column precision and validation.

## Architecture

### 1. eval_instructions.md
- **Purpose**: Direct SQL generation rules with strict validation
- **Key Features**:
  - Mandatory pre-query validation process
  - Column counting rules
  - String matching strategy
  - SQLite function reference
  - Failure pattern warnings

### 2. agent.md
- **Purpose**: Comprehensive database analysis
- **Key Features**:
  - Complete schema extraction
  - Data pattern discovery
  - Relationship mapping
  - String analysis for LIKE vs = decisions
  - Database-specific warnings

### 3. tools/ (optional)
- Can use analysis tools if provided
- Falls back to direct SQL queries if not

## Key Innovations

### The Validation Process
1. **Classify Question Type** - Determines expected output structure
2. **Count Required Columns** - Enforces exact column counts
3. **Validate Schema Elements** - Verifies all tables/columns exist

### String Matching Strategy
- Default to LIKE for names and text
- Use = for codes and enums
- Documented per-column recommendations

### The Simplicity Principle
- Simple queries succeed, complex queries fail
- Always choose the simpler approach
- Specific patterns for common operations

## Success Formula

The agent emphasizes five critical success factors:
1. **Count columns obsessively**
2. **Default to LIKE for strings**
3. **Choose simple over complex**
4. **Verify schema exists**
5. **Return ONLY what's asked**

## Top 3 Causes of Failure

Based on empirical analysis:
1. **#1**: Returning extra columns
2. **#2**: Wrong string matching
3. **#3**: Unnecessary complexity

## Benefits of Three-Artifact Structure

### Clean Separation
- SQL rules in eval_instructions (static)
- Database analysis in agent output (dynamic)
- No mixing of concerns

### No Information Loss
- All validation rules pass through unchanged
- Complete SQL guidance reaches eval model
- Database context adds to, never replaces, instructions

### Evolution Potential
- Can improve validation rules independently
- Can enhance analysis without touching SQL rules
- Can add tools for specific analysis tasks

## Usage

This package provides:
- Strict column precision enforcement
- Comprehensive schema validation
- String matching guidance
- Simplicity-first approach
- Database-specific warnings

Perfect for databases where:
- Column precision is critical
- String matching varies by column
- Schema validation prevents errors
- Simple queries are preferred

## Performance Heritage

Based on the original column_precision_guardian which achieved:
- Strong performance on BIRD benchmark
- Excellent column precision
- Reduced failure rates from extra columns

This three-artifact version maintains all strategies while providing better separation of concerns.