"""
Configuration settings for RoboPhD Text-to-SQL Research System
"""

# Model configuration with pricing from official Anthropic pricing
SUPPORTED_MODELS = {
    'opus-4.1': {
        'name': 'claude-opus-4-1-20250805',
        'pricing': {
            'input': 15.00,      # $15/MTok
            'output': 75.00,     # $75/MTok
            'cache_write': 18.75, # $18.75/MTok
            'cache_read': 1.50    # $1.50/MTok
        }
    },
    'sonnet-4': {
        'name': 'claude-sonnet-4-20250514', 
        'pricing': {
            'input': 3.00,       # $3/MTok
            'output': 15.00,     # $15/MTok
            'cache_write': 3.75,  # $3.75/MTok
            'cache_read': 0.30    # $0.30/MTok
        }
    },
    'haiku-3.5': {
        'name': 'claude-3-5-haiku-20241022',
        'pricing': {
            'input': 0.80,       # $0.80/MTok
            'output': 4.00,      # $4/MTok
            'cache_write': 1.00,  # $1/MTok
            'cache_read': 0.08    # $0.08/MTok
        }
    }
}

# Model to Claude CLI name mapping
# Claude CLI expects simple aliases: 'opus', 'sonnet', 'haiku'
CLAUDE_CLI_MODEL_MAP = {
    'opus-4.1': 'opus',      # CLI expects 'opus' not 'opus-4.1'
    'sonnet-4': 'sonnet',    # CLI expects 'sonnet' not 'sonnet-4'
    'haiku-3.5': 'haiku'     # CLI expects 'haiku' not 'haiku-3.5'
}

# Model fallback configuration for Claude CLI
MODEL_FALLBACKS = {
    'opus-4.1': 'sonnet',    # opus falls back to sonnet
    'sonnet-4': 'haiku',     # sonnet falls back to haiku
    'haiku-3.5': None        # haiku has no fallback
}

# Default model settings
DEFAULT_MODEL = 'sonnet-4'
MODEL_NAME = SUPPORTED_MODELS[DEFAULT_MODEL]['name']
MAX_TOKENS = 1000
DEFAULT_MAX_CONCURRENT_DBS = 10

# API settings
API_KEY_ENV_VAR = "ANTHROPIC_API_KEY_FOR_TEXT2SQL_RESEARCH"

# File paths
DEFAULT_DEV_DATA = "benchmark_resources/datasets/dev/dev_20240627/dev.json"
DEFAULT_DB_ROOT = "benchmark_resources/datasets/dev/dev_20240627/dev_databases"
DEFAULT_DEV_SQL = "benchmark_resources/datasets/dev/dev_20240627/dev.sql"

# Evaluation settings
EVALUATION_TIMEOUT = 5  # seconds per SQL query

# Subprocess timeout settings
ANALYZER_TIMEOUT = 3600  # 60 minutes for database analysis (large databases need time)
FALLBACK_SQL = "SELECT 1;"