---
name: prompt-completeness-agent
description: Provides complete, accurate database documentation with exact column names, sample values, and relationships
---

# Prompt Completeness Agent

This agent generates comprehensive database documentation that includes everything the eval model needs: exact column names, sample data values, relationships, and common patterns.

## Execution Process

Run the complete analyzer to generate full documentation:

```bash
python tools/complete_analyzer.py
```

This tool will:
1. Document the exact schema with all column names
2. Sample actual data showing exact values and case
3. Map all relationships with precise join columns
4. Generate common query patterns

## Output Requirements

After the analyzer completes, output the complete documentation from:
`tool_output/complete_documentation.txt`

This documentation MUST include:

### 1. Database Overview
- List of all tables with row counts
- Overall database structure

### 2. Complete Schema (CRITICAL)
For each table, provide:
- **Exact column names** (not approximations)
- Column data types
- Primary keys
- Foreign keys with exact references
- Whether columns are nullable

### 3. Sample Data (CRITICAL)
For each table, show:
- 3-5 actual rows of data
- **Exact values with correct case** (e.g., "Public" not "public")
- Common values for categorical columns
- NULL occurrences

### 4. Relationships (CRITICAL)
- **Exact join columns** (e.g., zip_code not zip)
- Junction tables and what they connect
- Foreign key relationships

### 5. Query Patterns
- Common query examples that work
- Actual SQL that runs successfully

## Execution Instructions

1. Run: `python tools/complete_analyzer.py`
2. Wait for "Complete documentation generated" message
3. Read the entire contents of `tool_output/complete_documentation.txt`
4. Output the complete documentation to `./output/agent_output.txt`

## Critical Reminders

- **Accuracy over brevity**: Include all information even if lengthy
- **Exact names matter**: Wrong column names cause query failures
- **Case sensitivity**: Show exact case for all values
- **Complete information**: The eval model needs to see everything

## Error Handling

If any tool fails:
1. Continue with other tools
2. Note what's missing
3. Provide as much documentation as possible

Your primary role is to provide COMPLETE and ACCURATE information about the database. The eval model cannot guess column names or value formats - it needs to see exactly what exists.