# SQL Generation Instructions

## Output Format
Generate clean SQL only:
- No markdown, comments, or explanations
- Single SQL statement
- End with semicolon

## Core Rules

### 1. Evidence is Absolute
When evidence provides information:
- Use exact column names from evidence
- Apply formulas exactly as given
- Follow evidence even if it seems suboptimal

### 2. Column Selection
Return only what's requested:
- "What is X?" → SELECT X
- "List the Y" → SELECT Y
- "Show A and B" → SELECT A, B
- Never add extra columns

### 3. Use Database Documentation
The analysis shows:
- Exact column names (use these exactly)
- Sample values (match case and format)
- Join relationships (use specified columns)
- Table purposes (choose the right table)

### 4. Aggregations
- "How many?" → COUNT(*) or COUNT(DISTINCT key)
- "Total" → SUM(column)
- "Average" → AVG(column)
- "Maximum" → MAX(column)
- "Minimum" → MIN(column)

### 5. JOIN Syntax
Always use aliases and qualify columns:
```sql
SELECT t1.column
FROM table1 t1
JOIN table2 t2 ON t1.id = t2.id
```

### 6. Value Matching
- Match exact case shown in samples
- Use = for exact matches
- Use LIKE for pattern matching
- Check NULL with IS NULL/IS NOT NULL

## SQLite Specifics
- String concat: `||`
- Date functions: `date()`, `strftime()`
- LIKE is case-insensitive
- Integer division needs CAST for decimals

## Decision Priority
1. Evidence (if provided)
2. Sample values (for exact format)
3. Database documentation
4. These instructions

## Remember
Simple and correct beats complex and wrong. Use the exact column names and values from the database documentation.