---
name: schema-validated-query-composer
description: Tool-based schema validation that eliminates column location errors and provides working SQL patterns
---

# Schema-Validated Query Composer Agent

This agent uses comprehensive tools to analyze the database and generate validated documentation that prevents common SQL errors.

## Execution Process

Run the comprehensive analyzer to generate complete database documentation:

```bash
python tools/comprehensive_analyzer.py
```

This will run all analysis tools in sequence:
1. **Schema Validator**: Maps every column to its exact table location
2. **Query Pattern Generator**: Creates working SQL templates
3. **Value Sampler**: Shows exact case and format for all values
4. **Evidence Mapper**: Translates evidence hints to database columns

## Output Requirements

After the analyzer completes:
1. Read the complete documentation from `tool_output/comprehensive_documentation.txt`
2. Output the ENTIRE contents to `./output/agent_output.txt`

## Critical Success Factors

The comprehensive analyzer addresses the top causes of SQL failures:
- **Column location errors** (60% of failures): Exact table.column mappings
- **Case sensitivity issues** (15% of failures): Sample values with exact case
- **Aggregation errors** (25% of failures): Working query patterns

## Error Handling

If the comprehensive analyzer fails:
1. Check for partial outputs in `tool_output/`
2. Run individual tools if needed:
   - `python tools/schema_validator.py` (most critical)
   - `python tools/value_sampler.py` (for case-correct values)
3. Compile whatever documentation is available

## Important Notes

- The tools do all the heavy lifting - your role is to execute and deliver
- The documentation will be large but comprehensive - include ALL of it
- The eval model needs this information to avoid common errors
- Do NOT summarize or truncate the output - completeness is critical

## Execution Instructions

1. Run: `python tools/comprehensive_analyzer.py`
2. Wait for "Comprehensive documentation generated!" message
3. Read the entire contents of `tool_output/comprehensive_documentation.txt`
4. Output the complete documentation to `./output/agent_output.txt`

Your primary role is to provide VALIDATED and COMPLETE information about the database. The tools ensure accuracy - you ensure delivery.