---
name: precision-schema-validator
description: Cross-pollinated agent combining comprehensive validation, template mining, and evidence translation for maximum accuracy
---

# Precision Schema Validator Agent

This agent executes a comprehensive validation suite that addresses the top causes of SQL generation failures through hierarchical validation levels.

## Execution Process

Run the comprehensive validator to generate complete database documentation:

```bash
python tools/comprehensive_validator.py
```

This orchestrator will execute four validation levels in sequence:
1. **Schema Validation**: Maps every column to its exact table location
2. **Value Validation**: Samples actual values with exact case and format
3. **Pattern Generation**: Creates working SQL templates
4. **Evidence Translation**: Provides rules for interpreting evidence hints

## Output Requirements

After the validator completes:
1. Read the complete documentation from `tool_output/comprehensive_documentation.txt`
2. Output the ENTIRE contents to `./output/agent_output.txt`

## Critical Success Factors

The hierarchical validation addresses the top SQL failure causes:
- **Column location errors (60% of failures)**: Level 1 provides exact table.column mappings
- **Case sensitivity issues (15% of failures)**: Level 2 shows exact case for all values
- **Syntax errors (15% of failures)**: Level 3 provides working query templates
- **Evidence misinterpretation (10% of failures)**: Level 4 translates evidence patterns

## Important Notes

- **Do NOT summarize or truncate** - The eval model needs ALL information
- **Include everything** - Even if the output is lengthy, completeness is critical
- **Trust the tools** - They perform validated analysis; your role is delivery
- **Preserve formatting** - The hierarchical structure helps the eval model navigate

## Error Handling

If the comprehensive validator encounters issues:
1. Check for partial outputs in `tool_output/`:
   - `schema_mapping.json` (most critical)
   - `value_samples.json` (for case-correct values)
   - `query_patterns.json` (for SQL templates)
   - `evidence_rules.txt` (for evidence interpretation)
2. If the main validator fails, try running individual tools:
   ```bash
   python tools/schema_mapper.py
   python tools/value_validator.py
   python tools/pattern_generator.py
   python tools/evidence_translator.py
   ```
3. Compile whatever documentation is available

## Execution Instructions

1. Run: `python tools/comprehensive_validator.py`
2. Wait for completion message
3. Read the entire contents of `tool_output/comprehensive_documentation.txt`
4. Output the complete documentation to `./output/agent_output.txt`

Your primary role is to provide **VALIDATED and COMPLETE** information about the database. The tools ensure accuracy through multiple validation levels - you ensure complete delivery to the eval model.