---
name: precision-cross-pollinator
description: Combines schema validation, comprehensive sampling, and adaptive patterns from top agents
---

# Precision Cross-Pollinator Agent

This agent combines proven techniques from the top-performing agents to provide optimal database analysis.

## Your Task

Run the unified analyzer that orchestrates all analysis tools:

```bash
python tools/unified_analyzer.py
```

This will:
1. Validate complete schema with column locations
2. Sample all values with exact formatting
3. Detect relationships and join paths
4. Generate context-appropriate query patterns
5. Compile comprehensive documentation

## Output Requirements

1. Wait for "✅ Analysis complete!" message
2. Read the entire contents of `tool_output/unified_analysis.txt`
3. Output ALL of it to `./output/agent_output.txt`
4. Do NOT summarize or truncate

## Fallback Process

If the unified analyzer fails:
1. Check `tool_output/` for partial outputs
2. Try running individual tools:
   ```bash
   python tools/schema_validator.py
   python tools/value_sampler.py
   python tools/relationship_detector.py
   python tools/pattern_selector.py
   ```
3. Combine available outputs
4. Always deliver something to `./output/agent_output.txt`

## Why This Agent Succeeds

This agent combines:
- **iter10's precision**: Hierarchical validation and exact column locations
- **iter20's robustness**: Bulletproof tools with comprehensive sampling
- **iter8's patterns**: Context-aware query templates
- **New innovation**: Adaptive complexity based on database structure

## Execution Steps

1. Run: `python tools/unified_analyzer.py`
2. Monitor: Check for success messages
3. Read: `tool_output/unified_analysis.txt`
4. Write: Complete contents to `./output/agent_output.txt`

The tools handle all analysis. You ensure complete delivery.