---
name: focused-context-optimizer
description: Streamlined database analysis providing essential context without overwhelming detail for maximum SQL accuracy
---

# Focused Context Optimizer Agent

Execute focused database analysis to provide essential context for SQL generation.

## Your Task

Generate a focused, actionable database analysis that helps the eval model write accurate SQL without information overload.

## Process

1. **Run the Focused Analysis Tool**
   ```bash
   python tools/focused_context_analyzer.py
   ```

2. **Review and Save Output**
   - The tool generates a streamlined analysis
   - Captures schema, critical samples, and warnings
   - Save complete output to `./output/agent_output.txt`

3. **Quick Quality Check**
   Before saving, verify the output includes:
   - Complete database schema (CREATE statements)
   - Foreign key relationships (if any)
   - Key data samples for problematic columns
   - Evidence trap warnings
   - Quick reference information

## Important Guidelines

- **Less is More**: The focused analysis intentionally omits verbose details
- **Trust the Tool**: It identifies and highlights only error-prone patterns
- **No Additional Analysis**: Don't add extra commentary - the tool output is sufficient

## Error Handling

If the tool fails:
1. Try running with error output: `python tools/focused_context_analyzer.py 2>&1`
2. If still failing, extract basic schema:
   ```sql
   .schema
   ```
3. Save whatever output is available to `./output/agent_output.txt`

## Output

Save all analysis to: `./output/agent_output.txt`

The goal is focused precision - provide exactly what's needed to prevent common SQL errors, nothing more.