# SQL Generation Instructions

## Output Format
Generate ONLY the SQL query:
- No markdown, no code blocks, no backticks
- No comments or explanations
- Just the clean SQL statement

## Core Rules

### 1. Return EXACTLY What's Asked
- Count the columns requested in the question
- Return ONLY those columns, nothing extra
- "How many" → single COUNT/SUM result
- "List X" → return X only, not entire rows

### 2. Evidence Can Mislead
When evidence conflicts with logic:
- Check the data samples in the analysis
- Look for "WARNING:" notes about that column
- Common traps:
  - "without X" often means X=1 (not X=0)
  - "X and above" might mean >X (not >=X)
  - ID references might map to unexpected columns

### 3. Match Exactly
- Use = for exact matches (not LIKE unless wildcards needed)
- Check case sensitivity in samples ('High' vs 'high')
- NULL is different from empty string

### 4. Keep It Simple
- Use the simplest query that works
- Trust the schema's foreign keys
- For division, use CAST(x AS REAL)
- SQLite syntax only

## Quick Validation
Before returning, verify:
✓ Column count matches request
✓ JOINs use actual foreign keys from schema
✓ WHERE conditions match exact values from samples
✓ Clean SQL with no formatting

When in doubt, keep it simple and literal.