# Agent Mapping for Production Run 5 (Ablate Research)

This file maps the internal agent names (as they appear in the research runs) to their production names with run prefixes.

## Pass 0 Agents (from parallel_agent_20250907_195056)

| Production Name | Internal Name | Source Iteration | Performance |
|-----------------|---------------|------------------|-------------|
| pass0_precision_tools_orchestrator | iter2_precision_tools_orchestrator | Iteration 2 | 48.2% mean |
| pass0_template_miner_agent | iter3_template_miner_agent | Iteration 3 | 51.2% |

## Agents from robophd_20250915_141448

| Production Name | Internal Name | Source Iteration | Performance | Evolution Strategy |
|-----------------|---------------|------------------|-------------|-------------------|
| 0915_i002_schema_value_miner | iter2_schema_value_miner | Iteration 2 | 66.4% mean (42 tests) | research_driven |
| 0915_i012_evidence_precision_orchestrator | iter12_evidence_precision_orchestrator | Iteration 12 | 67.9% mean (22 tests) | use_judgment_focus_on_errors |
| 0915_i016_precision_value_mapper | iter16_precision_value_mapper | Iteration 16 | 67.1% mean (15 tests) | refinement |
| 0915_i022_refined_csc_orchestrator | iter22_refined_csc_orchestrator | Iteration 22 | 65.2% mean (7 tests) | refinement |
| 0915_i028_resilient_value_mapper | iter28_resilient_value_mapper | Iteration 28 | 66.3% mean (15 tests) | refinement |
| 0915_i044_domain_aware_value_miner | iter44_domain_aware_value_miner | Iteration 44 | 68.0% mean (13 tests) | refinement |
| 0915_i060_column_order_precision | iter60_column_order_precision | Iteration 60 | 69.3% mean (10 tests) | refinement |

### Notable Performance:
- **0915_i002_schema_value_miner**: ELO 1584, won 19 iterations including 7-11 streak
- **0915_i012_evidence_precision_orchestrator**: ELO 1624 (highest), won 9 iterations, took lead at iteration 54
- **0915_i016_precision_value_mapper**: ELO 1542, won 10 iterations including 23-27 streak
- **0915_i022_refined_csc_orchestrator**: ELO 1538, won 3 iterations (22, 31, 38), parent of iter39_domain_adaptive_csc
- **0915_i028_resilient_value_mapper**: ELO 1626 (final leader), won 8 iterations (28, 37, 73, 75-80), took final lead at iteration 73
- **0915_i044_domain_aware_value_miner**: ELO 1542, won 6 iterations, took lead at iteration 55
- **0915_i060_column_order_precision**: ELO 1651, won 10 iterations (60-66, 67-68, 71), refined from iter12_evidence_precision_orchestrator

## Baseline Agents

| Name | Description | Performance |
|------|-------------|-------------|
| minimal_3a | Ultra-lightweight baseline with natural language analysis | 60.2% mean (initial run) |
| baseline | Raw DDL schema output only (no analysis) | TBD |

## Evolution Strategies Used

### parallel_agent_20250907_195056 Run:
- **Iteration 2**: use_your_judgment_with_tools → pass0_precision_tools_orchestrator
- **Iteration 3**: use_your_judgment_be_different_with_tools → pass0_template_miner_agent

### robophd_20250915_141448 Run (80 iterations):
- **Iteration 2**: research_driven → 0915_i002_schema_value_miner
- **Iteration 12**: use_judgment_focus_on_errors → 0915_i012_evidence_precision_orchestrator
- **Iteration 16**: refinement → 0915_i016_precision_value_mapper
- **Iteration 22**: refinement → 0915_i022_refined_csc_orchestrator
- **Iteration 28**: refinement → 0915_i028_resilient_value_mapper
- **Iteration 44**: refinement → 0915_i044_domain_aware_value_miner
- **Iteration 60**: refinement → 0915_i060_column_order_precision

## Agents from robophd_20250918_235319

| Production Name | Internal Name | Source Iteration | Performance | Evolution Strategy |
|-----------------|---------------|------------------|-------------|-------------------|
| 0917_i010_precision_column_separator | iter10_precision_column_separator | Iteration 10 | 68.8% mean (4 tests) | refinement |

### Notable Performance:
- **0917_i010_precision_column_separator**: ELO 1583 (highest in 20-iteration run), won 3 iterations (10, 19, 20), took lead at iteration 20

## Agents from robophd_20250919_231305

| Production Name | Internal Name | Source Iteration | Performance | Evolution Strategy |
|-----------------|---------------|------------------|-------------|-------------------|
| 0919_i024_selective_precision_optimizer | iter24_selective_precision_optimizer | Iteration 24 | 66.4% mean (48 tests) | Unknown |
| 0919_i048_evidence_first_executor | iter48_evidence_first_executor | Iteration 48 | 66.3% mean (16 tests) | Unknown |

### Notable Performance:
- **0919_i024_selective_precision_optimizer**: ELO 1708 (highest), won 31 iterations, best agent overall
- **0919_i048_evidence_first_executor**: ELO 1641, won 7 iterations including iterations 48, 56-58, 64-65, 75

## Agents from robophd_20250922_215639

| Production Name | Internal Name | Source Iteration | Performance | Evolution Strategy |
|-----------------|---------------|------------------|-------------|-------------------|
| 0922_i010_refined_clarity_agent | iter10_refined_clarity_agent | Iteration 10 | 65.3% mean (9 tests) | Unknown |

### Notable Performance:
- **0922_i010_refined_clarity_agent**: ELO 1638, tested across 9 iterations (10-12, 19-23, 25)

## Agents from robophd_20250923_224854

| Production Name | Internal Name | Source Iteration | Performance | Evolution Strategy |
|-----------------|---------------|------------------|-------------|-------------------|
| 0923_i013_focused_context_optimizer | iter13_focused_context_optimizer | Iteration 13 | 67.1% mean (15 tests) | Unknown |

### Notable Performance:
- **0923_i013_focused_context_optimizer**: ELO 1666, tested across 15 iterations (13-30)

## Notes

- The robophd_20250915_141448 run achieved strong results with iter12_evidence_precision_orchestrator reaching ELO 1624
- The robophd_20250918_235319 run achieved best results with iter10_precision_column_separator reaching ELO 1583 in just 20 iterations
- The robophd_20250919_231305 run achieved the best overall results with iter24_selective_precision_optimizer reaching ELO 1708
- The five selected agents from 0915 run represent three different evolution strategies: research_driven, use_judgment_focus_on_errors, and refinement
- iter2_schema_value_miner served as the "super-ancestor" for many refinement-based winners, with 34 dynasty wins
- iter44_domain_aware_value_miner achieved the highest first-iteration accuracy (75.9%) among all agents
- iter22_refined_csc_orchestrator is part of the iter21_csc_validation_orchestrator lineage (Dynasty 3 per refinement_ancestry_analysis.md)
- These agents collectively won 47 of the 60 iterations in the research run (now 57 with iter60_column_order_precision)
- **baseline** agent created Sep 2025 provides raw DDL output only, serving as absolute minimum baseline for SQL generation without any analysis