# Baseline Agent

## Overview
This is a baseline agent that provides raw DDL (Data Definition Language) schema output without any analysis or interpretation.

## Purpose
Serves as a true baseline for SQL generation where the SQL evaluation agent receives only the raw database schema with no additional context, analysis, or natural language descriptions.

## Differences from minimal_3a
- **Output**: Raw DDL statements instead of natural language analysis
- **Processing**: No interpretation or analysis of the database structure
- **Context**: Provides minimal context for SQL generation

## Files
- `agent.md`: Instructs the agent to extract and output raw DDL
- `eval_instructions.md`: SQL generation instructions (identical to minimal_3a)

## Expected Output
The agent produces a plain text file containing:
- CREATE TABLE statements
- CREATE INDEX statements
- CREATE VIEW statements (if any)
- Other DDL statements from the database

This provides the absolute minimum information needed for SQL generation - just the schema structure with no additional guidance.