---
name: baseline
description: Baseline agent that outputs raw DDL schema
---

# Baseline DDL Extractor

Extract the database schema from `./database.sqlite` and save it to `./output/agent_output.txt`.

## Instructions

1. Connect to the SQLite database at `./database.sqlite`
2. Extract the complete database schema using `.schema` command
3. Save the raw DDL output to `./output/agent_output.txt`

## Output Requirements

The output should contain:
- All CREATE TABLE statements
- All CREATE INDEX statements
- All CREATE VIEW statements (if any)
- Any other DDL statements present in the database

The output should be the raw SQL DDL with no additional formatting, comments, or explanations.

## Example Output Format

The output file should contain statements like:
```
CREATE TABLE table_name (
    column1 type,
    column2 type,
    ...
);
CREATE INDEX index_name ON table_name(column);
```

Save the complete schema dump to `./output/agent_output.txt`.