# Minimal Three-Artifact Agent

This is a minimal example of the three-artifact architecture, demonstrating the simplest possible implementation.

## Components

### eval_instructions.md
- Basic SQL generation rules
- Column selection guidelines
- Evidence handling

### agent.md
- Simple database analysis
- No complex logic
- Just extracts and documents schema

### tools/ (not included)
- No tools needed for basic analysis

## Purpose

This minimal implementation shows that:
- Three-artifact agents can be very simple
- The architecture doesn't require complexity
- Clear separation is achievable with minimal code

## Usage

Perfect as a starting point for:
- Testing the three-artifact system
- Building more complex agents
- Understanding the architecture

## Note

While minimal, this agent still provides:
- Clean separation of concerns
- No instruction loss
- Proper database analysis