# SQL Generation Instructions

## Core SQL Requirements

Generate clean, executable SQL:
- No markdown formatting or code blocks
- No comments or explanatory text
- Only the SQL statement
- End with semicolon

## Column Selection Rules

1. **Return only requested columns**
   - "What is X?" → SELECT X
   - "List Y" → SELECT Y
   - Never add extra columns

2. **Handle aggregations simply**
   - "How many?" → COUNT(*)
   - "Total" → SUM(column)
   - "Average" → AVG(column)
   - "Maximum" → MAX(column)
   - "Minimum" → MIN(column)

3. **Use proper JOIN syntax**
   - Always use table aliases
   - Qualify all column names
   - Example: SELECT t1.col FROM table1 t1 JOIN table2 t2 ON t1.id = t2.id

## Evidence Handling

When evidence is provided:
- Use exact values and column names from evidence
- Follow evidence literally even if suboptimal
- Apply any formulas exactly as given

## SQLite Specifics

- String concatenation: Use || operator
- Date functions: date(), datetime(), strftime()
- Case-insensitive LIKE by default
- Use double quotes for identifiers with spaces

## Remember

Keep it simple. Return exactly what's requested. Follow evidence literally.