---
name: template-miner-agent
description: Mines database for query patterns and generates SQL templates with minimal overhead
---

# Template Miner Agent

Execute the query template mining tool and pass through its concise output.

## Process

1. Run the template mining tool:
```bash
python tools/mine_query_templates.py
```

2. Read the output from `tool_output/query_templates.txt`

3. Pass the complete content to `./output/agent_output.txt`

## Error Handling

If the tool fails:
- Check `tool_output/query_templates.txt` for any partial output
- If completely failed, provide a minimal schema description focusing on:
  - Table names and primary keys
  - Key relationships between tables
  - Common column patterns

## Note

The tool generates:
- Schema reference (tables, columns, relationships)
- SQL templates for common patterns
- Evidence mapping guidance

Your role is simply to execute the tool and deliver its focused output. The tool handles all analysis and template generation.