# Claude Code Agents for Text2SQL Research

This directory contains specialized Claude Code agents (subagents) that can be invoked using the Task tool to automate complex research workflows.

## Available Agents

### research-run-finalizer

Automates the complete finalization workflow for parallel agent research runs.

#### What It Does

1. **Identifies the champion agent** from final_report.md based on ELO score
2. **Traces complete genealogy** including parent agents and research papers
3. **Deploys to production** by copying to ape/agents/ with clean naming
4. **Updates documentation** in EXPERIMENTAL_CHANGELOG.md
5. **Creates archives** both minimal and full compressed versions

#### Usage

```python
# Basic usage - finalize a completed research run
Task(
    subagent_type="research-run-finalizer",
    description="Finalize research run", 
    prompt="Please finalize the research run at research/parallel_agent_20250903_185519/"
)

# With specific instructions
Task(
    subagent_type="research-run-finalizer",
    description="Finalize and focus on genealogy",
    prompt="""
    Finalize research/parallel_agent_20250903_185519/ with extra attention to:
    - Complete genealogy tracing including all research papers
    - Identify any multi-influence patterns
    - Create detailed EXPERIMENTAL_CHANGELOG entry
    """
)
```

#### Expected Output

The agent will provide a structured summary:

```
RESEARCH RUN FINALIZATION COMPLETE
==================================
Run ID: parallel_agent_20250903_185519
Champion: iter12_precision_synthesis_enhanced → precision_synthesis_enhanced
Performance: 57.5% accuracy, ELO 1621

Actions Completed:
✓ Identified champion from final report
✓ Traced complete genealogy (4 generations, 8 ancestors)
✓ Copied to ape/agents/precision_synthesis_enhanced
✓ Updated EXPERIMENTAL_CHANGELOG.md
✓ Created minimal archive in research_archive/
✓ Created full archive: parallel_agent_20250903_185519_2025-09-04.tar.gz

Key Findings:
- iter8_omnisql_inspired_analyzer has triple influence across generations
- Incorporated Li et al. (2025) OmniSQL paper insights
- Cross-pollination strategy was most effective

Notes: Phase 1 failures cleared from iteration 9
```

## How Claude Code Agents Work

Claude Code agents are specialized instruction sets that can be invoked through the Task tool. They:

1. **Receive a specific task** via the prompt parameter
2. **Have access to specified tools** (Read, Write, Edit, Bash, etc.)
3. **Follow structured workflows** defined in their agent file
4. **Return structured output** for easy interpretation

## Creating New Agents

To create a new Claude Code agent:

1. **Create the agent definition** in `agent_name.md`:
   - Clear role description
   - Step-by-step workflow
   - Error handling guidelines
   - Output format specification

2. **Create metadata** in `agent_name_metadata.json`:
   - Name and version
   - Required tools
   - Usage examples
   - Configuration settings

3. **Document usage** in this README

4. **Test the agent** using the Task tool

## Agent Design Principles

1. **Single Responsibility**: Each agent should do one thing well
2. **Structured Workflow**: Clear, sequential steps
3. **Comprehensive Error Handling**: Graceful degradation
4. **Informative Output**: Structured summaries of actions taken
5. **Idempotent Operations**: Safe to run multiple times

## Integration with APE Research

These Claude Code agents are designed to work with the APE (Agentic Prompt Evolution) research system:

- **research-run-finalizer**: Post-research workflow automation
- Future agents could handle:
  - Research run initialization
  - Mid-run checkpointing and analysis
  - Agent performance comparison
  - Evolution strategy selection

## Troubleshooting

### Agent Not Found
If the Task tool reports "agent not found", ensure:
- The agent name matches exactly (case-sensitive)
- The agent file exists in this directory
- The metadata file is valid JSON

### Permission Errors
The agent needs appropriate permissions for:
- Reading research directories
- Writing to ape/agents/
- Creating archives
- Updating documentation

### Incomplete Execution
If the agent stops partway:
- Check for missing files (final_report.md, checkpoint.json)
- Verify research run completed successfully
- Review agent output for specific errors

## Future Enhancements

Potential improvements for these agents:
- Automatic dev set evaluation of champions
- Git commit creation for changes
- Slack/email notifications on completion
- Comparative analysis across multiple runs
- Automatic agent performance regression detection