#!/bin/sh

# Get the directory where this script is located
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Path to the .anthropic_key file
KEY_FILE="$SCRIPT_DIR/.anthropic_key"

# Check if the file exists
if [ ! -f "$KEY_FILE" ]; then
    echo "Error: .anthropic_key file not found in script directory" >&2
    exit 1
fi

# Read the contents of the file and trim whitespace
KEY_CONTENT=$(cat "$KEY_FILE" | tr -d '\n\r' | sed 's/^[[:space:]]*//;s/[[:space:]]*$//')

# Check if the contents are empty after trimming
if [ -z "$KEY_CONTENT" ]; then
    echo "Error: .anthropic_key file is empty or contains only whitespace" >&2
    exit 1
fi

# Return the key content
echo "$KEY_CONTENT"