#!/usr/bin/env python3
"""Quick evaluation progress checker"""

import subprocess
import os
import re

# Check if process is running
try:
    result = subprocess.run(['ps', '-p', '80662'], capture_output=True, text=True)
    is_running = result.returncode == 0
except:
    is_running = False

print("=== Evaluation Progress Check ===")
print(f"Process 80662: {'RUNNING' if is_running else 'COMPLETED'}")

# Check log file for progress
log_file = "evaluation_results/initial_dev_baseline/evaluation.log"
if os.path.exists(log_file):
    with open(log_file, 'r') as f:
        content = f.read()
    
    # Find all progress updates
    progress_matches = re.findall(r'Processed (\d+)/(\d+) questions', content)
    
    if progress_matches:
        last_processed, total = progress_matches[-1]
        percentage = (int(last_processed) / int(total)) * 100
        print(f"Progress: {last_processed}/{total} questions ({percentage:.1f}%)")
        
        # Estimate time remaining
        log_lines = content.count('\n')
        if log_lines > 0:
            avg_lines_per_question = log_lines / int(last_processed)
            remaining_questions = int(total) - int(last_processed)
            print(f"Remaining: {remaining_questions} questions")
    else:
        print("Waiting for first progress update...")

# Check output file
output_file = "evaluation_results/initial_dev_baseline/full_cached_evaluation.json"
if os.path.exists(output_file):
    size = os.path.getsize(output_file)
    print(f"Output file size: {size:,} bytes ({size/1024/1024:.1f} MB)")
else:
    print("Output file not created yet")

# Check cache sizes
cache_files = [
    "cache/ground_truth/ground_truth_cache.json",
    "cache/predictions/initial_dev_baseline_cache.json"
]
for cache_file in cache_files:
    if os.path.exists(cache_file):
        size = os.path.getsize(cache_file)
        print(f"{os.path.basename(cache_file)}: {size/1024/1024:.1f} MB")