#!/bin/bash
# Monitor evaluation progress

echo "=== Monitoring Evaluation Progress ==="
echo "PID: 80662"
echo ""

while true; do
    # Check if process is still running
    if ! ps -p 80662 > /dev/null; then
        echo "Process completed!"
        break
    fi
    
    # Count processed questions from log
    processed=$(grep -c "Processed" evaluation_results/initial_dev_baseline/evaluation.log 2>/dev/null || echo "0")
    
    # Get last progress update
    last_progress=$(grep "Processed" evaluation_results/initial_dev_baseline/evaluation.log 2>/dev/null | tail -1)
    
    # Check output file size
    if [ -f "evaluation_results/initial_dev_baseline/full_cached_evaluation.json" ]; then
        size=$(ls -lh evaluation_results/initial_dev_baseline/full_cached_evaluation.json | awk '{print $5}')
        echo "$(date '+%H:%M:%S') - Output file size: $size"
    fi
    
    if [ ! -z "$last_progress" ]; then
        echo "$(date '+%H:%M:%S') - $last_progress"
    else
        echo "$(date '+%H:%M:%S') - Waiting for first progress update..."
    fi
    
    sleep 10
done

echo ""
echo "=== Evaluation Complete ==="
echo "Check evaluation_results/initial_dev_baseline/full_cached_evaluation.json for results"