import gurobipy as gp
from gurobipy import GRB
import numpy as np


def distance(point1, point2):
    return np.linalg.norm(np.array(point1) - np.array(point2))



def linear_programming_slove_cost_wt(datasets, colors, weights, centers, p, q):
    N = len(datasets)
    K = len(centers)
    a = p / (p + q)
    b = q / (p + q)
    if (0.5 - a > b - 0.5):
        a = 1 - b
    else:
        b = 1 - a
    # cost function, distance
    c_ij = np.array([[distance(datasets[i], centers[j]) for j in range(K)] for i in range(N)])

    # creat modle
    model = gp.Model("Balanced_k_Median_Clustering")

    # variable x_ij
    x = model.addVars(N, K, vtype=GRB.CONTINUOUS, name="x", lb=0, ub=1)

    # objective function
    model.setObjective(gp.quicksum(c_ij[i][j] * x[i, j] * weights[i] for i in range(N) for j in range(K)), GRB.MINIMIZE)

    # constraints
    # Type one:
    for i in range(N):
        model.addConstr(gp.quicksum(x[i, j] for j in range(K)) == 1, name=f"assign_{i}")
    # Type two:
    for j in range(K):
        if colors[i] not in [0, 1]:
            raise ValueError(f"Invalid value at index {i}: {colors[i]}. Expected 0 or 1.")
        T1 = gp.quicksum(x[i, j] for i in range(N) if colors[i] == 0)
        T2 = gp.quicksum(x[i, j] for i in range(N) if colors[i] == 1)
        T = gp.quicksum(x[i, j] for i in range(N))
        model.addConstr(T1 - a * T >= 0, name=f"type1_balance_lower_{j}")
        model.addConstr(b * T - T1 >= 0, name=f"type1_balance_upper_{j}")
        model.addConstr(T2 - a * T >= 0, name=f"type2_balance_lower_{j}")
        model.addConstr(b * T - T2 >= 0, name=f"type2_balance_upper_{j}")


    # solve model
    model.optimize()

    # output
    if model.status == GRB.OPTIMAL:
        print("Optimal cost found:", model.objVal)  # output the cost
        return model.objVal
    else:
        print(model.objVal)
        print("Failed to find optimal cost.")
        return 0


def linear_programming_slove_cost(datasets, colors, centers, p, q):
    N = len(datasets)
    K = len(centers)
    a = p / (p + q)
    b = q / (p + q)
    if (0.5 - a > b - 0.5):
        a = 1 - b
    else:
        b = 1 - a
    # cost function, distance
    c_ij = np.array([[distance(datasets[i], centers[j]) for j in range(K)] for i in range(N)])

    # creat modle
    model = gp.Model("Balanced_k_Median_Clustering")

    # variable x_ij
    x = model.addVars(N, K, vtype=GRB.BINARY, name="x")


    # objective function
    model.setObjective(gp.quicksum(c_ij[i][j] * x[i, j] for i in range(N) for j in range(K)), GRB.MINIMIZE)

    # constraints
    # Type one:
    for i in range(N):
        model.addConstr(gp.quicksum(x[i, j] for j in range(K)) == 1, name=f"assign_{i}")
    # Type two:
    for j in range(K):
        if colors[i] not in [0, 1]:
            raise ValueError(f"Invalid value at index {i}: {colors[i]}. Expected 0 or 1.")
        T1 = gp.quicksum(x[i, j] for i in range(N) if colors[i] == 0)
        T2 = gp.quicksum(x[i, j] for i in range(N) if colors[i] == 1)
        T = gp.quicksum(x[i, j] for i in range(N))
        model.addConstr(T1 - a * T >= 0, name=f"type1_balance_lower_{j}")
        model.addConstr(b * T - T1 >= 0, name=f"type1_balance_upper_{j}")
        model.addConstr(T2 - a * T >= 0, name=f"type2_balance_lower_{j}")
        model.addConstr(b * T - T2 >= 0, name=f"type2_balance_upper_{j}")


    # solve model
    model.optimize()

    # output
    if model.status == GRB.OPTIMAL:
        print("Optimal cost found:", model.objVal)  # output the cost
        return model.objVal
    else:
        print(model.objVal)
        print("Failed to find optimal cost.")
        return 0





# test
# linear_programming_slove_cost([[1,2,3],[2,1,3],[3,1,2],[4,3,1],[2,4,3]], [0,0,1,1,1], [2,3,2,1,2], [[1,2,3],[4,3,1]], 1, 9)