import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.Scanner;
import java.util.Collections;
import java.util.Arrays;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;



import base.ColorGroup;
import base.Point;
import base.Utility;
import base.WeightedPoint;

public class Main
{

	// the following methods is used to fetch the dataset, according to DataDescriptor.
	public ArrayList<WeightedPoint> adultBinary() throws Exception
	{
		return DataUtil.getData(DataDescriptor.adultBinary());
	}
	
	public ArrayList<WeightedPoint> bankBinary() throws Exception
	{
		return DataUtil.getData(DataDescriptor.bankBinary());
	}
	
	
	public ArrayList<WeightedPoint> diabetesBinary() throws Exception
	{
		return DataUtil.getData(DataDescriptor.diabetesBinary());
	}

	public ArrayList<WeightedPoint> census1990Binary() throws Exception
	{
		return DataUtil.getData(DataDescriptor.census1990Binary());
	}
	
	public ArrayList<WeightedPoint> athlete() throws Exception
	{
		return DataUtil.getData(DataDescriptor.athlete());
	}
	
	void evaluateFairTree(List<WeightedPoint> instance, int p, int q, int k, String name) throws Exception
	{
		PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File("../output/" + name + "_tree_weight.csv"))));
		out.println("current_timestamp,cor_obj,uni_obj,Borassi_obj,benchmark");

		// Using online-coreset.py to generate coreset
		File tmp = File.createTempFile("aaa", "bbb");
		// tmp.deleteOnExit();
		feedInput(instance, new FileOutputStream(tmp), true);
		System.out.println(tmp.getAbsolutePath());
		
		Process process = new ProcessBuilder("python3", "../online-coreset.py", "" + k, "" + p, "" + q, tmp.getAbsolutePath()).redirectError(new File("/tmp/qqqwwwe.err")).start();
		Scanner scan = new Scanner(process.getInputStream());
		String resultJson = null;
		int timeValue = 0;
		double corObj = 0.00;
		double uniObj = 0.00;
		double benchmark = 0.00;
		double Borassicost = 0.00;
		while (scan.hasNext()) 
		{
			String line = scan.nextLine();
			// System.out.println("Python output: " + line); // Print every line from standard output
			if (line.startsWith("TIME:")) {
				String timeValueStr = line.substring(5);
				timeValue = Integer.parseInt(timeValueStr);
			}
			if (line.startsWith("RESULT:")){
				// resultJson = line.substring(7);
				String Json = line.substring(7);
				// Split two strings using the delimiter "###"
				String[] parts = Json.split("###");
				String sliding_json = parts[0];  // The first string
				resultJson = parts[1];      // The second string
				List<WeightedPoint> sliding_window_coreset = build_online_coreset(resultJson, instance, k);
				System.out.println("Size of sliding_window_coreset: " + sliding_window_coreset.size());
				List<WeightedPoint> node_in_window = instance.subList(timeValue - 500 + 1, timeValue); 
				// 500 is the window size, which can be adjusted according to the data set
				List<List<Double>> coordinatesList = new ArrayList<>();
				StringBuilder cgSb = new StringBuilder(); 
				List<Double> weightList = new ArrayList<>(); 

				// for (WeightedPoint wp : node_in_window) {
				for (WeightedPoint wp : sliding_window_coreset) {
					List<Double> coorList = new ArrayList<>();
					for (double coord : wp.data.coor) {
						coorList.add(coord); 
					}
					coordinatesList.add(coorList);
    				cgSb.append(wp.cg.toList().get(0) == 0 ? 0 : 1).append(" ");
					weightList.add(wp.weight);
				}

				StringBuilder sb = new StringBuilder();
				for (List<Double> point : coordinatesList) {
					sb.append("[");
					for (Double d : point) {
						sb.append(d).append(",");
					}
					sb.deleteCharAt(sb.length() - 1);
					sb.append("] ");
				}
				
				String coordinatesStr = sb.toString().trim();
				String cgStr = cgSb.toString().trim();
				String weightStr = String.join(" ", weightList.stream().map(String::valueOf).toArray(String[]::new));


				List<WeightedPoint> ourCoreset = build_online_coreset(resultJson, instance, k);
				System.out.println("ourCoreset size: " + ourCoreset.size());
				double minValue = Double.MAX_VALUE;
				boolean hasNonZero = false;
				for (int i = 0; i < 1; i++){
					FairTree ft = new FairTree(ourCoreset);
					Object[] ret = ft.getResult(p, q, k, true, FairTree.fairwt, coordinatesStr, cgStr, weightStr);
					corObj = (Double)ret[0];
					if (corObj != 0){
						hasNonZero = true; // if find non-zero number
                		minValue = Math.min(minValue, corObj);
					}
				}
				if (hasNonZero){
					corObj = minValue;
				}
				System.out.print("Uniform Coreset Size: ");
				System.out.println(ourCoreset.size());


				List<WeightedPoint> coreset = new Uniform(node_in_window).getCoreset(ourCoreset.size());
				System.out.println("Uniform coreset size: " + coreset.size());
				minValue = Double.MAX_VALUE;
				hasNonZero = false;
				for (int i = 0; i < 1; i++){
					FairTree ft = new FairTree(coreset);
					Object[] ret = ft.getResult(p, q, k, true, FairTree.fairwt, coordinatesStr, cgStr, weightStr);
					uniObj = (Double)ret[0];
					if (uniObj != 0){
						hasNonZero = true; // if find non-zero number
                		minValue = Math.min(minValue, uniObj);
					}
				}
				if (hasNonZero){
					uniObj = minValue;
				}

				minValue = Double.MAX_VALUE;
				hasNonZero = false;
				for (int i = 0; i < 1; i++){
					FairTree ft = new FairTree(sliding_window_coreset);
					// FairTree ft = new FairTree(node_in_window);
					Object[] ret = ft.getResult(p, q, k, true, FairTree.fairwt, coordinatesStr, cgStr, weightStr);
					benchmark = (Double)ret[0];
					if (benchmark != 0){
						hasNonZero = true; // if find non-zero number
                		minValue = Math.min(minValue, benchmark);
					}
				}
				if (hasNonZero){
					benchmark = minValue;
				}
			}
			if (line.startsWith("COST:")) {
				String coststr = line.substring(5); // Extract the part after "COST:"
				Borassicost = Double.parseDouble(coststr);
				System.out.println(coststr);
				System.out.printf("%d,%.8f,%.8f,%.8f,%.8f\n", timeValue, corObj, uniObj, Borassicost, benchmark);
				out.printf("%d,%.8f,%.8f,%.8f,%.8f\n", timeValue, corObj, uniObj, Borassicost, benchmark);
			}
		}
		scan.close();

		// Capture erroneous output
		Scanner errorScanner = new Scanner(process.getErrorStream());
		while (errorScanner.hasNextLine()) {
			System.err.println("Error: " + errorScanner.nextLine()); // Print erroneous output
		}
		errorScanner.close();


		process.waitFor();
		out.close();
	}

	void feedInput(List<WeightedPoint> instance, OutputStream os, boolean weighted)
	{
		PrintWriter out = new PrintWriter(new BufferedOutputStream(os));
		for (int i = 0; i < instance.size(); i++)
		{
			WeightedPoint wp = instance.get(i);
			if (weighted)
			{
				{
					out.printf("%d,%d,", wp.cg.toList().get(0) == 0 ? 0 : 1, (int)Math.round(wp.weight));
					for (int j = 0; j < wp.data.dim; j++)
					{
						out.printf("%.8f", wp.data.coor[j]);
						if (j != wp.data.dim - 1)
							out.print(',');
						else
							out.println();
					}
				}
			}
			else
			{
				for (int cnt = 0; cnt < (int)Math.round(wp.weight); cnt++)
				{
					out.printf("%d,", wp.cg.toList().get(0) == 0 ? 0 : 1);
					for (int j = 0; j < wp.data.dim; j++)
					{
						out.printf("%.8f", wp.data.coor[j]);
						if (j != wp.data.dim - 1)
							out.print(',');
						else
							out.println();
					}
				}
			}
		}
		out.flush();
	}
	
	ArrayList<WeightedPoint> build_online_coreset(String resultJson, List<WeightedPoint> instance, int k) throws Exception
	{
		Process process = null;
		int node = 0;
		ArrayList<WeightedPoint> res = new ArrayList<WeightedPoint>();
		try
		{
			// Parsing JSON
			if (resultJson != null) {
				JSONParser parser = new JSONParser();
				try {
					JSONArray resultArray = (JSONArray) parser.parse(resultJson);
					for (int i = 0; i < resultArray.size(); i++) {
						JSONObject point = (JSONObject) resultArray.get(i);
						JSONArray coordinates = (JSONArray) point.get("coordinates");
						Number weightNumber = (Number) point.get("weight");
						double weight = weightNumber.doubleValue(); 

						long timestamp = (long) point.get("timestamp");
						int color = ((Long) point.get("color")).intValue();
						double[] coordArray = new double[coordinates.size()];
						for (int j = 0; j < coordinates.size(); j++) {
							coordArray[j] = ((Number) coordinates.get(j)).doubleValue(); 
						}
						res.add(new WeightedPoint(new Point(coordArray), (int) weight, new ColorGroup(new int[]{color})));

					}
				} catch (ParseException e) {
					e.printStackTrace();
				}
            } else {
                System.out.println("No result in json found from Python output.");
            }
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return res;
	}
	
	public void run() throws Exception
	{
        final int k = 10;
		
		ArrayList<WeightedPoint> instance = null;
		
		instance = adultBinary();
		evaluateFairTree(instance, 1, 9, k, "adult");
		
		// instance = bankBinary();
		// evaluateFairTree(instance, 1, 9, k, "bank");
		
		// instance = athlete();
		// evaluateFairTree(instance, 1, 9, k, "athlete");
		
		// instance = diabetesBinary();
		// evaluateFairTree(instance, 1, 9, k, "diabetes");
		
		// instance = census1990Binary();
		// evaluateFairTree(instance, 1, 9, k, "census1990");
	}
	
	public static void main(String[] args) throws Exception
	{
		new Main().run();
	}
}
